# 迷宫
通过给植物[施肥](docs/unlocks/fertilizer.md)获得的 `Items.Weird_Substance` 对灌木有奇怪的效果。如果在无人机位于灌木上方时调用 `use_item(Items.Weird_Substance, amount)`，灌木将长成一个树篱迷宫。
迷宫的大小取决于使用的 `Items.Weird_Substance` 的数量（`use_item()` 调用的第二个参数）。
未升级迷宫时，使用 `n` 份 `Items.Weird_Substance` 将生成一个 `n`x`n` 的迷宫。每次迷宫升级都会使宝藏中的金币数量翻倍，但所需的 `Items.Weird_Substance` 数量也会随之翻倍。
所以若要生成一个全场迷宫：

`plant(Entities.Bush)
substance = get_world_size() * 2**(num_unlocked(Unlocks.Mazes) - 1)
use_item(Items.Weird_Substance, substance)`


出于某种原因，无人机无法飞过树篱，尽管树篱看起来并没有那么高。

树篱中隐藏着一份宝藏。对宝藏使用 `harvest()` 可以获得等于迷宫面积的金币。（例如，一个 5x5 的迷宫将产出 25 份金币。）

如果在其他任何地方使用 `harvest()`，迷宫将直接消失。

如果无人机在宝藏上方，则 `get_entity_type()` 等于 `Entities.Treasure`，在迷宫的其他地方则等于 `Entities.Hedge`。

除非重复使用迷宫（关于如何重复使用迷宫，请见下文），否则迷宫不包含任何循环。因此，无人机不可能在不回头的情况下再次到达相同的位置。

你可以通过尝试穿过墙壁来检查是否有墙。
`move()` 如果成功则返回 `True`，否则返回 `False`。

`can_move()` 可以用来在不移动的情况下检查是否有墙。

如果不知道如何到达宝藏所在处，请看提示 1，其中说明了如何处理这样的问题。

在迷宫中的任何地方使用 `measure()` 都会返回宝藏的位置。
`x, y = measure()`

为了增加挑战，你也可以通过在宝藏上再次使用相同数量的 `Items.Weird_Substance` 来重复使用迷宫。
这将使宝藏中的金币增加一个完整迷宫份的量，并将其移动到迷宫中的一个随机位置。

每次宝藏被移动时，迷宫中的一些墙壁可能会被随机移除。所以重复使用的迷宫可能包含循环。

请注意，迷宫中的循环会显著提升难度，因为循环意味着你可以在不回头的情况下再次到达相同的位置。
重复使用迷宫得到的金币也并不会比直接收获并生成一个新迷宫更多。
这百分百是一个可以直接跳过的额外挑战。
只有当额外的信息和捷径能帮助你更快地破解迷宫时，才值得重复使用迷宫。

宝藏最多可以被重新定位 300 次。之后，在宝藏上使用奇异物质将不再增加其中的金币，并且它将不再移动。

<spoiler=显示提示 1>以下是解决这个问题的一种通用方法：

创建一个迷宫，并想象你是无人机。

思考一下如果你在迷宫中会如何尝试找到宝藏。

一步步写下你的策略，清晰到可以让其他人不加思考地照办。

现在尝试将你的步骤翻译成代码。
</spoiler>
<spoiler=显示提示 2>只要没有循环，那么所有的墙壁实际上只是一长串的相连墙壁。如果沿着墙走，就会走遍整个迷宫。
这种方法需要编写的代码很少，而且不必记录已经去过的地方。大约 10 行代码就足够了。</spoiler>
<spoiler=显示提示 3>与其让无人机朝东西南北这样的绝对方向移动，朝相对方向（如“右转”或“左转”）移动可能更加实用。为此，你需要记录无人机当前移动的方向。无人机实际上从不旋转，但你仍然可以在代码中保持“虚拟”的旋转。
下面的索引技巧对此很有帮助：

`directions = [North, East, South, West]
index = 0`

使用 `% 4` 来让无人机“绕圈”旋转，这样在 `West` 之后它会绕回到 `North`。
`# 右转
index = (index + 1) % 4`

`# 左转
index = (index - 1) % 4

move(directions[index])`</spoiler>
<spoiler=显示提示 4>如果无法破解也不必为难自己，你始终可以选择效率更低的方式。
破解一个 `1`x`1` 的迷宫总归是小菜一碟。</spoiler>